﻿# タイトル：楽天検索順位バッチ(自動実行)版
# 説明    ：楽天市場において特定店舗の商品の表示順位を調査する
# 
# 著作権  ：
# 会社名  ：
# 
# 変更履歴：2022.06.10 新規登録
#         ：2022.06.30 レビュー後の修正を反映
#         ：2022.07.04 不具合修正、Homeを統一

#param($inifile="\\pgmspss\Work\楽天検索順位\楽天検索順位.ini")
param($inifile="楽天検索順位.ini")

Remove-Job -State Completed

Write-Host $inifile

# 初期値
$homedir = "C:\Program Files\楽天検索順位"
$MaxSearchPage = 5

$dt = (Get-Date).ToString("yyyyMMdd")

Get-Content $inifile | Foreach-Object {
    $name, $value = $_.split(',', 2)
    Invoke-Expression "`$$name='$value'"
}

$libdir = $homedir + "\bin"
$importfile = $homedir + "\import\ImportFile.csv"
$exportfile = $homedir + "\export\SaveFile.csv"
$logfile = $homedir + "\log\logfile.txt"

Write-Host "検索データ="$importfile
Write-Host "結果ファイル="$exportfile
Write-Host "ログファイル="$logfile
Write-Host "ライブラリ="$libdir
Write-Host "検索対象ページ最大="$MaxSearchPage

$Env:logfile = $logfile

If(Test-Path -path $logfile) {
    Remove-Item $logfile
}

"検索データ=" + $importfile | Out-File -FilePath $Env:logfile
"結果ファイル=" + $exportfile | Out-File -FilePath $Env:logfile -Append
"ログファイル=" + $logfile | Out-File -FilePath $Env:logfile -Append
"検索対象ページ最大=" + $MaxSearchPage | Out-File -FilePath $Env:logfile -Append

. $libdir\Library.ps1

If(Test-Path -path $Importfile) {
    $data = @(ReadImportfile $Importfile)
}

if ($data.length -gt 0) {
    $URLText = $data[$data.length - 1].店舗URL -replace "@", "`r`n"
    $KeyWord = $data[$data.length - 1].キーワード -replace "@", "`r`n"
    $KeyWords = $KeyWord -split "`r`n"

    for ($i = 0; $i -lt $KeyWords.length; $i++) {
        $header = "`n[" + [Int]($i + 1) + "] 検索 店舗:" + $URLText + " キーワード:" + $KeyWords[$i]
        Write-Host $header
        $header | Out-File -FilePath $Env:logfile -Append

        $KeyWord = $KeyWords[$i] -replace (" ", "+")
        $data = @(SearchHTML $MaxSearchPage $URLText $KeyWord)

        for ($j = 0; $j -lt $data.length; $j++) {
            SaveEntry $exportfile $data[$j].店舗 $KeyWords[$i] $data[$j].商品管理番号 $data[$j].順位 $data[$j].価格 $data[$j].スコア $data[$j].件数 $data[$j].商品名
            $logmessage = $data[$j].店舗 + " 順位:" + $data[$j].順位 + " " + $商品名
			Write-Host $logmessage
        }
    }
}
else {
    $tm = (Get-Date).ToString("HH:mm:ss")
    Write-Host "$tm 検索店舗とキーワードが見つかりません。"
}
$tm = (Get-Date).ToString("HH:mm:ss")
Write-Host "$tm Search End. Done."