﻿# タイトル：楽天検索順位GUI版
# 説明    ：楽天市場において特定店舗の商品の表示順位を調査する
# 
# 著作権  ：
# 会社名  ：
# 
# 変更履歴：2022.06.10 新規登録
#         ：2022.06.30 レビュー後の修正を反映
#         ：2022.07.04 不具合修正、Homeを統一
# 
#param($inifile="\\pgmspss\Work\楽天検索順位\楽天検索順位.ini")
param($inifile="楽天検索順位.ini")

Remove-Job -State Completed

Write-Host $inifile

# 初期値
$homedir = "C:\Program Files\楽天検索順位"
$MaxSearchPage = 5

$dt = (Get-Date).ToString("yyyyMMdd")

Get-Content $inifile | Foreach-Object {
    $name, $value = $_.split(',', 2)
    Invoke-Expression "`$$name='$value'"
}

$libdir = $homedir + "\bin"
$importfile = $homedir + "\import\ImportFile.csv"
$exportfile = $homedir + "\export\SaveFile.csv"
$logfile = $homedir + "\log\logfile.txt"

Write-Host "検索データ="$importfile
Write-Host "結果ファイル="$exportfile
Write-Host "ログファイル="$logfile
Write-Host "ライブラリ="$libdir
Write-Host "検索対象ページ最大="$MaxSearchPage
Write-Host "検索後終了待ち時間="$StopSleep

$Env:logfile = $logfile

If(Test-Path -path $logfile) {
    Remove-Item $logfile
}

"検索データ=" + $importfile | Out-File -FilePath $Env:logfile
"結果ファイル=" + $exportfile | Out-File -FilePath $Env:logfile -Append
"ログファイル=" + $logfile | Out-File -FilePath $Env:logfile -Append
"検索対象ページ最大=" + $MaxSearchPage | Out-File -FilePath $Env:logfile -Append

. $libdir\Library.ps1

function EntryButton_Click () {
    $Sites = $URLTextBox.Text -Replace "`r`n", "@"
    $KeyWord = $KeyWordTextBox.Text -Replace "`r`n", "@"

    $ret = SaveSearchEntry $Sites $KeyWord
}

function SearchButton_Click () {
    $URLText = $URLTextBox.Text

    $KeyWord = $KeyWordTextBox.Text -Replace ("　", " ")
#   $KeyWord = $KeyWord -replace (" ", "+")
    $KeyWords = $KeyWord -split "`r`n"

    $logmessage = ""

    for ($i = 0; $i -lt $KeyWords.length; $i++) {
        $header = "`n[" + [Int]($i + 1) + "] 検索 店舗:" + $URLText + " キーワード:" + $KeyWords[$i]
        Write-Host $header
        $header | Out-File -FilePath $Env:logfile -Append

        $KeyWord = $KeyWords[$i] -replace (" ", "+")
        $data = @(SearchHTML $MaxSearchPage $URLText $KeyWord)

        for ($j = 0; $j -lt $data.length; $j++) {
            SaveEntry $exportfile $data[$j].店舗 $KeyWords[$i] $data[$j].商品管理番号 $data[$j].順位 $data[$j].価格 $data[$j].スコア $data[$j].件数 $data[$j].商品名

            $商品名 = $data[$j].商品名.substring(0, 30)
            $logmessage = $logmessage + $data[$j].店舗 + " 順位:" + $data[$j].順位 + " " + $商品名 + "`n"
        }
    }
    $ResultMessage.Text = $logmessage

    $tm = (Get-Date).ToString("HH:mm:ss")
    $logmessage = "$tm Search End and it'll exit after $StopSleep seconds."
    Write-Host $logmessage

    $CommentLabel.Text = $logmessage
    Start-Sleep $StopSleep

    $form.Visible = $false
    $form.Dispose()
}

If(Test-Path -path $Importfile) {
    $data = @(ReadImportfile $Importfile)
}

#アセンブリの読み込み
[void] [System.Reflection.Assembly]::LoadWithPartialName("System.Drawing")
[void] [System.Reflection.Assembly]::LoadWithPartialName("System.Windows.Forms")

$Font = New-Object System.Drawing.Font("メイリオ",10,[System.Drawing.FontStyle]::Bold)
#$label.Font = $Font
 
#フォームの設定
$Form = New-Object System.Windows.Forms.Form
$Form.Size = New-Object System.Drawing.Size(600, 800)
$Form.Text = "楽天の検索順位を調べて、結果をCSVで残す"

#URLテキストボックスのラベル
$label = New-Object System.Windows.Forms.Label
$label.Location = New-Object System.Drawing.Point(10,20)
$label.Size = New-Object System.Drawing.Size(280,20)
$label.Text = 'URL:'
$form.Controls.Add($label)
$label.Font = $Font

#URLテキストボックスの設定
$URLTextBox = New-Object System.Windows.Forms.Textbox
$URLTextBox.Location = New-Object System.Drawing.Point(10,40)
$URLTextBox.Size = New-Object System.Drawing.Size(100,40)
$URLTextBox.Text = $data.店舗URL -replace "@", "`r`n"
$URLTextBox.Multiline = $True
$URLTextBox.WordWrap = $False
$URLTextBox.ScrollBars = [System.Windows.Forms.ScrollBars]::Vertical
$Form.Controls.Add($URLTextBox)

#キーワードテキストボックスのラベル
$label = New-Object System.Windows.Forms.Label
$label.Location = New-Object System.Drawing.Point(10,100)
$label.Size = New-Object System.Drawing.Size(280,20)
$label.Text = 'キーワード:'
$Form.Controls.Add($label)
$label.Font = $Font

#キーワードテキストボックスの設定
$KeyWordTextBox = New-Object System.Windows.Forms.Textbox
$KeyWordTextBox.Location = New-Object System.Drawing.Point(10,120)
$KeyWordTextBox.Size = New-Object System.Drawing.Size(400,200)
$KeyWordTextBox.Multiline = $True
$KeyWordTextBox.ScrollBars = [System.Windows.Forms.ScrollBars]::Vertical
$Form.Controls.Add($KeyWordTextBox)
$KeyWordTextBox.Text = $data.キーワード -replace "@", "`r`n"

#ボタンの設定
$EntryButton = New-Object System.Windows.Forms.Button
$EntryButton.Location = New-Object System.Drawing.Point(10,350)
$EntryButton.Size = New-Object System.Drawing.Size(100,50)
$EntryButton.Text = "登録"
$Form.Controls.Add($EntryButton)
$EntryButton.Add_Click({EntryButton_Click})
$EntryButton.Font = $Font

#ボタンの設定
$SearchButton = New-Object System.Windows.Forms.Button
$SearchButton.Location = New-Object System.Drawing.Point(210,350)
$SearchButton.Size = New-Object System.Drawing.Size(100,50)
$SearchButton.Text = "検索"
$Form.Controls.Add($SearchButton)
$SearchButton.Add_Click({SearchButton_Click})
$SearchButton.Font = $Font

#リザルトメッセージ
$ResultMessage = New-Object System.Windows.Forms.Label
$ResultMessage.Location = New-Object System.Drawing.Point(10,410)
$ResultMessage.AutoSize = $True
$ResultMessage.TextAlign = "TopLeft"
$ResultMessage.Text = ""
$Font1 = New-Object System.Drawing.Font("メイリオ", 8,[System.Drawing.FontStyle]::Regular)
$ResultMessage.Font = $Font1
$Form.Controls.Add($ResultMessage)

#メッセージ
$CommentLabel = New-Object System.Windows.Forms.Label
$CommentLabel.Location = New-Object System.Drawing.Point(10,670)
$CommentLabel.AutoSize = $True
$CommentLabel.TextAlign = "TopLeft"
$CommentLabel.Text = ""
$Font1 = New-Object System.Drawing.Font("メイリオ", 8,[System.Drawing.FontStyle]::Regular)
$CommentLabel.Font = $Font1
$Form.Controls.Add($CommentLabel)

#フォームの表示
$Form.Add_Shown({$Form.Activate()})
[void]$Form.ShowDialog()