﻿function SaveSearchEntry ($Sites, $KeyWord) {
    $日付 = (Get-Date).ToString("yyyy/MM/dd")

    If(Test-Path -path $importfile) {
#        $Date = "_" + (Get-Date).ToString("yyyyMMdd") + ".csv"
#        $backupfile = $importfile -replace "`.csv", $Date
#
#        for ($i = 0; 1; $i++) {
#            if (Test-Path -path $backupfile) {
#                
#                $Date = "_" + (Get-Date).ToString("yyyyMMdd") + "_" + [String]($i + 1) + ".csv"
#                $backupfile = $importfile -replace "`.csv", $Date
#            }
#            else {
#                break
#            }
#        }
#
#        Copy-Item $importfile $backupfile
#        Set-ItemProperty $importfile -Name IsReadOnly -Value $false
    }
    else {
        $message = "店舗URL`tキーワード"
        $message | Out-File -FilePath $importfile
    }
    $message = $Sites + "`t" + $KeyWord
    $message | Out-File -FilePath $importfile -Append
#
#    Set-ItemProperty $importfile -Name IsReadOnly -Value $true
}

function SaveEntry ($exportfile, $店舗, $KeyWord, $商品管理番号, $順位, $価格, $スコア, $件数, $商品名) {
    $日付 = (Get-Date).ToString("yyyy/MM/dd")

    If(Test-Path -path $exportfile) {
        ;
    }
    else {
        $message = "店舗URL`tキーワード`t商品管理番号`t日付`t順位`t価格`tスコア`t件数`t商品名"
        $message | Out-File -FilePath $exportfile
    }
    $KeyWord = $KeyWord -replace "`r`n", " "
    $message = $店舗 + "`t" + $KeyWord + "`t" + $商品管理番号 + "`t" + $日付 + "`t" + $順位 + "`t" + $価格 + "`t" + $スコア + "`t" + $件数 + "`t" + $商品名
    $message | Out-File -FilePath $exportfile -Append
}

function _SearchHTML ($MaxSearchPage, $URLText, $KeyWord) {
    $data = @()
    $順位 = 0

    [Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12

	for ($Page = 1; $Page -le $MaxSearchPage; $Page++) {
		$URL = "https://search.rakuten.co.jp/search/mall/" + $KeyWord + "?p=" + $Page
		Write-Host "URL:" $URL
		
#       [Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
		$webReq = [Net.HttpWebRequest]::Create($URL)
		$webReq.Method = "GET"
		$webReq.UserAgent = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; .NET CLR 1.0.3705; .NET CLR 1.1.4322)"
	
#       $webReq.Timeout = 10000
#       $webReq.MaximumAutomaticRedirections = 4
#       $webReq.MaximumResponseHeadersLength = 4
		$webRes = $webReq.GetResponse()
		$sr = New-Object IO.StreamReader($webRes.GetResponseStream(), $webRes.ContentEncoding)
		$content = $sr.ReadToEnd()
		$sr.Close()
		$webRes.Close()
		
		# 改行を削除
		$content = $content -replace "`n", ""
		$content = $content -replace "&nbsp;", ""
		$content = $content -replace "`"", ""
		$content = $content -replace "　", " "
	
		for ($i = 0; $i -lt 20; $i++) {
			$content = $content -replace "  ", " "
		}
	
		# ページが正しいか判定する
		$search_string = "<a class=item -active currentPage>"
		$start_pos = $content.IndexOf($search_string)
		if ($start_pos -ge 0) {
			$next_string = $content.Substring($start_pos + $search_string.length)
			$end_pos = $next_string.IndexOf("<")
			if ($end_pos -ge 0) {
				$ThisPage = [Int]($next_string.Substring(0, $end_pos).trim())
				if ($Thispage -ne $Page) {
					return $data
				}
			}
		}

		$content = $content -replace "<div class=dui-card searchresultitem", "`n<div class=dui-card searchresultitem"
		$divclass_s = $content -split "`n"
	
		foreach ($divclass in $divclass_s) {
            $店舗 = ""
            $商品管理番号 = ""
            $価格 = ""
            $商品名 = ""
            $スコア = ""
            $件数 = ""

            if ($divclass -match "^`n") {
                $divclass = $divclass -replace "`n", ""
            }

			if ($divclass -match "<div class=dui-card searchresultitem") {
#                if ($divclass -match "aquavinus") {
#                    Write-Host $divclass
#                }

				$divclass = $divclass -replace "<div class=", "`n<div class="
				$div_s = $divclass -split "`n"

                $PR = 0
	
				foreach ($div in $div_s) {
                    # 広告
                    if ($div -match "^<div class=image><a target=_top href=https://grp.*.rakuten.co.jp/redirect_") {
                        $PR = 1
                        break
                    }
					elseif ($div -match "^<div class=image><a target=_top href=") {
						$search_string = " alt="
						$start_pos = $div.IndexOf($search_string)
						if ($start_pos -ge 0) {
							$next_string = $div.Substring($start_pos + $search_string.length)
							$end_pos = $next_string.IndexOf("/></a>")
							if ($end_pos -ge 0) {
								$商品名 = $next_string.Substring(0, $end_pos).trim() -replace "`n", ""
                                $順位 = $順位 + 1
                                
                                #"`n〇順位:$順位" | Out-File -FilePath $Env:logfile -Append
                                #$divclass = $divclass -replace "^`n", ""
                                #$divclass | Out-File -FilePath $Env:logfile -Append
							}
						}
					}
					elseif ($div -match "^<div class=content description price><span class=important>") {
						$search_string = "<span class=important>"
						$start_pos = $div.IndexOf($search_string)
						if ($start_pos -ge 0) {
							$next_string = $div.Substring($start_pos + $search_string.length)
							$end_pos = $next_string.IndexOf("<")
							if ($end_pos -ge 0) {
								$価格 = $next_string.Substring(0, $end_pos).trim() -replace ",", ""
							}
						}
					}
                    elseif ($div -match "^<div class=favorite dui-menu-item data-shop-id=") {
						$search_string = "data-shop-id="
						$start_pos = $div.IndexOf($search_string)
						if ($start_pos -ge 0) {
							$next_string = $div.Substring($start_pos + $search_string.length)
							$end_pos = $next_string.IndexOf(" ")
							if ($end_pos -ge 0) {
								$shop_id = $next_string.Substring(0, $end_pos).trim()
							}
						}
						$search_string = "data-id="
						$start_pos = $div.IndexOf($search_string)
						if ($start_pos -ge 0) {
							$next_string = $div.Substring($start_pos + $search_string.length)
							$end_pos = $next_string.IndexOf(" ")
							if ($end_pos -ge 0) {
								$data_id = $next_string.Substring(0, $end_pos).trim()
							}
						}
						$search_string = "data-item-svid="
						$start_pos = $div.IndexOf($search_string)
						if ($start_pos -ge 0) {
							$next_string = $div.Substring($start_pos + $search_string.length)
							$end_pos = $next_string.IndexOf(" ")
							if ($end_pos -ge 0) {
								$data_item_svid = $next_string.Substring(0, $end_pos).trim()
							}
						}
						$search_string = "data-review-avg="
						$start_pos = $div.IndexOf($search_string)
						if ($start_pos -ge 0) {
							$next_string = $div.Substring($start_pos + $search_string.length)
							$end_pos = $next_string.IndexOf(" ")
							if ($end_pos -ge 0) {
								$data_review_avg = $next_string.Substring(0, $end_pos).trim()
							}
						}
						$search_string = "data-review-count="
						$start_pos = $div.IndexOf($search_string)
						if ($start_pos -ge 0) {
							$next_string = $div.Substring($start_pos + $search_string.length)
							$end_pos = $next_string.IndexOf(" ")
							if ($end_pos -ge 0) {
								$data_review_count = $next_string.Substring(0, $end_pos).trim()
							}
						}
                    }
				}
                if ($PR -eq 1) {
                    continue
                }
                $店舗URLs = $URLText -split "`r`n"
	
				for ($i = 0; $i -lt $店舗URLs.length; $i++) {
                    if ($divclass -match "<div class=image><a target=_top href=https://item`.rakuten`.co`.jp/") {
                        $search_string = "<div class=image><a target=_top href=https://item`.rakuten`.co.`jp/"
                        $start_pos = $divclass.IndexOf($search_string)
                        if ($start_pos -ge 0) {
							$next_string = $divclass.Substring($start_pos + $search_string.length)
							$end_pos = $next_string.IndexOf("/")
							if ($end_pos -ge 0) {
                                $店舗 = $next_string.Substring(0, $end_pos).trim()

                                $next_string = $next_string.Substring($end_pos + 1)
                                $end_pos = $next_string.IndexOf("/")
                                if ($end_pos -ge 0) {
								    $商品管理番号 = $next_string.Substring(0, $end_pos).trim()
                                }
							}
						}
                        break
                    }
				}
                for ($i = 0; $i -lt $店舗URLs.length; $i++) {
                    if ($店舗URLs[$i] -eq $店舗) {
                        break
                    }
                }
                if ($店舗.length -gt 0 -and $i -lt $店舗URLs.length) {
                    $message = "☆順位:" + $順位 + " 店舗:" + $店舗 + " 商品管理番号:" + $商品管理番号 + " 価格:" + $価格 + " shop_id:" + $shop_id + " data_id:" + $data_id + " item_svid:" + $data_item_svid + " スコア:" + $data_review_avg + " 件数:" + $data_review_count + " 商品名:" + $商品名

		            $data += ,@{
                        店舗 = [String]$店舗 ;
			            商品管理番号 = [String]$商品管理番号 ;
			            順位 = [String]$順位 ;
			            価格 = [String]$価格 ;
			            商品名 = [String]$商品名 ;
                        スコア = $data_review_avg ;
                        件数 = $data_review_count ;
                    }
		        }
                else {
                    $message = "　順位:" + $順位 + " 店舗:" + $店舗 + " 商品管理番号:" + $商品管理番号 + " 価格:" + $価格 + " shop_id:" + $shop_id + " data_id:" + $data_id + " item_svid:" + $data_item_svid + " スコア:" + $data_review_avg + " 件数:" + $data_review_count + " 商品名:" + $商品名
                }
				Write-Host $message
				$message | Out-File -FilePath $Env:logfile -Append
            }
        }
	}
	return $data
}

function SearchHTML ($MaxSearchPage, $URLText, $KeyWord) {
#   $KeyWord = $KeyWord -Replace "`r`n", "`%E3`%80`%80"

    $data = @(_SearchHTML $MaxSearchPage $URLText $KeyWord)

	return $data
}

function ReadImportfile ($file) {
    $csv = Import-Csv $file -Delimiter `t | Sort-Object -Property "店舗URL"
    
    $data = @()

    $n = 0
    
    Foreach ($Victim in $csv) {
		$店舗URL = $Victim."店舗URL"
		$キーワード = $Victim."キーワード"

        $data = ,@{
            店舗URL = [String]$店舗URL ;
            キーワード = [String]$キーワード ;
        }
        $message = "店舗URL=" + $店舗URL + " キーワード:" + $キーワード
        Write-Host $n $message

        $message | Out-File -FilePath $Env:logfile -Append
        $n++
    }
    return $data
}